﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Globalization;
using System.Web;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRDODDeploymentManager : AHOBPRBaseBO, IDeploymentManager
    {

        #region Deployment location search
        /// <summary>
        /// Get deploymentLocations by search Criteria
        /// </summary>
        /// <param name="searchCriteria"></param>
        /// <returns></returns>
        public BprDeploymentLocation[] GetDeploymentLocations(string searchCriteria)
        {
            if (string.IsNullOrEmpty(searchCriteria))
            {
                return (new List<BprDeploymentLocation>()).ToArray();
            }
            else
            {
                List<STD_DEPLOYMENT_LOCATION> locations = new List<STD_DEPLOYMENT_LOCATION>();
                string[] searches = searchCriteria.Split(' ');
                using (_dbAhobpr = GetDataContext())
                {
                    if (searches.Length == 1)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();

                    }
                    else if (searches.Length == 2)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 3)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 4)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                        && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                        && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 5)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                         && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                         && (e.NAMES.Contains(searches[4]) || e.COUNTRY.Contains(searches[4]) || e.BASE.Contains(searches[4])
                                            || e.PROVINCE.Contains(searches[4]) || e.OTHER_NAMES.Contains(searches[4]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                }

                List<BprDeploymentLocation> bprLocations = new List<BprDeploymentLocation>();
                foreach (STD_DEPLOYMENT_LOCATION location in locations)
                {
                    BprDeploymentLocation bprLocation = new BprDeploymentLocation();
                    bprLocation.@base = location.BASE;
                    bprLocation.names = location.NAMES;
                    bprLocation.otherNames = location.OTHER_NAMES;
                    bprLocation.province = location.PROVINCE;
                    bprLocation.country = location.COUNTRY;

                    bprLocations.Add(bprLocation);
                }

                return bprLocations.ToArray();
            }
        }
        #endregion
        /// <summary>
        ///  Get deploymentLocation base names by search Criteria
        /// </summary>
        /// <param name="searchCriteria"></param>
        /// <returns></returns>
        public BprDeploymentBaseName[] GetDeploymentBaseNames(string searchCriteria)
        {
            if (string.IsNullOrEmpty(searchCriteria))
            {
                return (new List<BprDeploymentBaseName>()).ToArray();
            }
            else
            {
                List<STD_DEPLOYMENT_LOCATION> locations = new List<STD_DEPLOYMENT_LOCATION>();
                string[] searches = searchCriteria.Split(' ');
                using (_dbAhobpr = GetDataContext())
                {
                    if (searches.Length == 1)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();

                    }
                    else if (searches.Length == 2)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 3)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 4)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                        && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                        && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                    else if (searches.Length == 5)
                    {
                        locations = (from e in _dbAhobpr.STD_DEPLOYMENT_LOCATIONs
                                     where (e.NAMES.Contains(searches[0]) || e.COUNTRY.Contains(searches[0]) || e.BASE.Contains(searches[0])
                                            || e.PROVINCE.Contains(searches[0]) || e.OTHER_NAMES.Contains(searches[0]))
                                         && (e.NAMES.Contains(searches[1]) || e.COUNTRY.Contains(searches[1]) || e.BASE.Contains(searches[1])
                                            || e.PROVINCE.Contains(searches[1]) || e.OTHER_NAMES.Contains(searches[1]))
                                         && (e.NAMES.Contains(searches[2]) || e.COUNTRY.Contains(searches[2]) || e.BASE.Contains(searches[2])
                                            || e.PROVINCE.Contains(searches[2]) || e.OTHER_NAMES.Contains(searches[2]))
                                         && (e.NAMES.Contains(searches[3]) || e.COUNTRY.Contains(searches[3]) || e.BASE.Contains(searches[3])
                                            || e.PROVINCE.Contains(searches[3]) || e.OTHER_NAMES.Contains(searches[3]))
                                         && (e.NAMES.Contains(searches[4]) || e.COUNTRY.Contains(searches[4]) || e.BASE.Contains(searches[4])
                                            || e.PROVINCE.Contains(searches[4]) || e.OTHER_NAMES.Contains(searches[4]))
                                     orderby e.BASE, e.NAMES
                                     select e).ToList();
                    }
                }

                List<BprDeploymentBaseName> bprBaseNames = new List<BprDeploymentBaseName>();
                foreach (STD_DEPLOYMENT_LOCATION location in locations)
                {
                    BprDeploymentBaseName bprBase = new BprDeploymentBaseName();
                    bprBase.@base = location.BASE + (string.IsNullOrEmpty(location.NAMES) || location.NAMES.ToLower() == "none" ? "" : " (" + location.NAMES + ")");
                    bprBaseNames.Add(bprBase);
                }

                return bprBaseNames.ToArray();
            }
        }  
    }

}
